/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.MatrixUtils;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIcon
extends Pane {
    private static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    private static final SpacerTextComponent FIX_VANILLA_TOOLTIP = new SpacerTextComponent(1);
    private ItemStack itemStack;

    public ItemIcon() {
    }

    public ItemIcon(PaneParams params) {
        super(params);
        Item item;
        String itemName = params.getString("item");
        if (itemName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))) != null) {
            this.setItem(item.m_7968_());
        }
    }

    public void setItem(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
        Pane pane = this.onHover;
        if (pane instanceof Tooltip) {
            Tooltip tooltip = (Tooltip)pane;
            tooltip.setTextOld(this.getModifiedItemStackTooltip());
        }
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        if (this.itemStack != null && !this.itemStack.m_41619_()) {
            ms.m_85836_();
            ms.m_85837_((double)this.x, (double)this.y, 0.0);
            ms.m_85841_((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
            MatrixUtils.pushShaderMVstack(ms);
            Font font = RenderProperties.get((ItemStack)this.itemStack).getFont(this.itemStack);
            if (font == null) {
                font = this.mc.f_91062_;
            }
            this.mc.m_91291_().m_115203_(this.itemStack, 0, 0);
            this.mc.m_91291_().m_115169_(font, this.itemStack, 0, 0);
            RenderSystem.m_69453_();
            RenderSystem.m_69461_();
            MatrixUtils.popShaderMVstack();
            ms.m_85849_();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && this.itemStack != null && !this.itemStack.m_41619_()) {
            PaneBuilders.tooltipBuilder().hoverPane(this).build().setTextOld(this.getModifiedItemStackTooltip());
        }
    }

    public List<Component> getModifiedItemStackTooltip() {
        if (this.itemStack == null) {
            return Collections.emptyList();
        }
        List result = this.window.getScreen().m_96555_(this.itemStack);
        result.add(1, FIX_VANILLA_TOOLTIP);
        return result;
    }
}

